<?php

// +------------------------------------------------------------------------+
// | AuthPuppy Authentication Server                                        |
// | ===============================                                        |
// |                                                                        |
// | AuthPuppy is the new generation of authentication server for           |
// | a wifidog based captive portal suite                                   |
// +------------------------------------------------------------------------+
// | PHP version 5 required.                                                |
// +------------------------------------------------------------------------+
// | Homepage:     http://www.authpuppy.org/                                |
// | Launchpad:    http://www.launchpad.net/authpuppy                       |
// +------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify   |
// | it under the terms of the GNU General Public License as published by   |
// | the Free Software Foundation; either version 2 of the License, or      |
// | (at your option) any later version.                                    |
// |                                                                        |
// | This program is distributed in the hope that it will be useful,        |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of         |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          |
// | GNU General Public License for more details.                           |
// |                                                                        |
// | You should have received a copy of the GNU General Public License along|
// | with this program; if not, write to the Free Software Foundation, Inc.,|
// | 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.            |
// +------------------------------------------------------------------------+


/**
 * BaseConnection
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $node_id
 * @property string $token
 * @property string $status
 * @property string $mac
 * @property string $ip
 * @property string $auth_type
 * @property string $identity
 * @property integer $incoming
 * @property integer $outgoing
 * @property Node $Node
 * 
 * @method integer    getNodeId()    Returns the current record's "node_id" value
 * @method string     getToken()     Returns the current record's "token" value
 * @method string     getStatus()    Returns the current record's "status" value
 * @method string     getMac()       Returns the current record's "mac" value
 * @method string     getIp()        Returns the current record's "ip" value
 * @method string     getAuthType()  Returns the current record's "auth_type" value
 * @method string     getIdentity()  Returns the current record's "identity" value
 * @method integer    getIncoming()  Returns the current record's "incoming" value
 * @method integer    getOutgoing()  Returns the current record's "outgoing" value
 * @method Node       getNode()      Returns the current record's "Node" value
 * @method Connection setNodeId()    Sets the current record's "node_id" value
 * @method Connection setToken()     Sets the current record's "token" value
 * @method Connection setStatus()    Sets the current record's "status" value
 * @method Connection setMac()       Sets the current record's "mac" value
 * @method Connection setIp()        Sets the current record's "ip" value
 * @method Connection setAuthType()  Sets the current record's "auth_type" value
 * @method Connection setIdentity()  Sets the current record's "identity" value
 * @method Connection setIncoming()  Sets the current record's "incoming" value
 * @method Connection setOutgoing()  Sets the current record's "outgoing" value
 * @method Connection setNode()      Sets the current record's "Node" value
 * 
 * @package    authpuppy
 * @author     Geneviève Bastien <gbastien@versatic.net>
 * @author     Philippe April <philippe@philippeapril.com>
 * @copyright  2010
 * @version    $Version: 0.1.0$
 */
abstract class BaseConnection extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('connections');
        $this->hasColumn('node_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('token', 'string', 255, array(
             'type' => 'string',
             'unique' => true,
             'notnull' => true,
             'length' => '255',
             ));
        $this->hasColumn('status', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '255',
             ));
        $this->hasColumn('mac', 'string', 255, array(
             'type' => 'string',
             'length' => '255',
             ));
        $this->hasColumn('ip', 'string', 255, array(
             'type' => 'string',
             'length' => '255',
             ));
        $this->hasColumn('auth_type', 'string', 255, array(
             'type' => 'string',
             'length' => '255',
             ));
        $this->hasColumn('auth_sub_type', 'string', 255, array(
             'type' => 'string',
             'length' => '255',
             ));
        $this->hasColumn('identity', 'string', 255, array(
             'type' => 'string',
             'length' => '255',
             ));
        $this->hasColumn('incoming', 'float', null, array(
             'type' => 'float',
             'default' => 0,
             ));
        $this->hasColumn('outgoing', 'float', null, array(
             'type' => 'float',
             'default' => 0,
             ));
        $this->hasColumn('user_agent', 'string', 500, array(
             'type' => 'string',
             'length' => 500,
             ));
        $this->hasColumn('disconnect_reason', 'string', 1000, array(
             'type' => 'string',
             'length' => 1000,
             ));

        $this->option('symfony', array(
             'form' => false,
             'filter' => false,
             'model' => true,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Node as NodeRel', array(
             'local' => 'node_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}