<?php

// +------------------------------------------------------------------------+
// | AuthPuppy Authentication Server                                        |
// | ===============================                                        |
// |                                                                        |
// | AuthPuppy is the new generation of authentication server for           |
// | a wifidog based captive portal suite                                   |
// +------------------------------------------------------------------------+
// | PHP version 5 required.                                                |
// +------------------------------------------------------------------------+
// | Homepage:     http://www.authpuppy.org/                                |
// | Launchpad:    http://www.launchpad.net/authpuppy                       |
// +------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify   |
// | it under the terms of the GNU General Public License as published by   |
// | the Free Software Foundation; either version 2 of the License, or      |
// | (at your option) any later version.                                    |
// |                                                                        |
// | This program is distributed in the hope that it will be useful,        |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of         |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          |
// | GNU General Public License for more details.                           |
// |                                                                        |
// | You should have received a copy of the GNU General Public License along|
// | with this program; if not, write to the Free Software Foundation, Inc.,|
// | 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.            |
// +------------------------------------------------------------------------+


/**
 * Node
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    authpuppy
 * @author     Geneviève Bastien <gbastien@versatic.net>
 * @author     Philippe April <philippe@philippeapril.com>
 * @copyright  2010
 * @version    $Version: 0.1.0$
 */
class Node extends BaseNode
{
  
  public function setUp() {
    parent::setUp();
    sfProjectConfiguration::getActive()->getEventDispatcher()->filter(new sfEvent($this,'node.set_up', array('node' => $this)),$this);
  }

  public function isOnline() {
    /* FIXME HARDCODED VALUE */
    if ($this->getLastHeartbeatAt() && time() - date_format(date_create($this->getLastHeartbeatAt()), "U") < 60*15) {
      return true;
    }
    return false;
  }

  public function expireOldConnections() {
    /* Find connections that haven't been updated in a little while */
    foreach ($this->getOnlineUsersQuery()->execute() as $conn) {
      $conn->expireIfNotRecentlyUpdated();
    }
  }
  
  public function save(Doctrine_Connection $conn = null)
  {
    $dispatcher = sfProjectConfiguration::getActive()->getEventDispatcher();
    $event_name = 'node.update';
    if ($this->isNew() )
    {
      $now = $this->getCreatedAt() ? $this->getDateTimeObject('created_at')->format('U') : time();
      $this->setCreatedAt(date('Y-m-d H:i:s', $now));
      $event_name = 'node.new';
    }
    $now = time();
    $this->setUpdatedAt(date('Y-m-d H:i:s', $now));
 
    $dispatcher->filter(new sfEvent($this,$event_name, array('node' => $this)),$this);
    return parent::save($conn);
  }
  
  /**
   * Prepares a query to fetch online users for this node
   * @return Doctrine_Query
   */
  protected function getOnlineUsersQuery() {
    $t = Doctrine::getTable('Connection');
    $q = $t->getQuery();
    $q = $t->addNodeQuery($q, $this->getId());
    $q = $t->addOnlineQuery($q);
    return $q;
  }
  
  /**
   * Returns the number of active connections on this node
   * @return int
   */
  public function getNumOnlineUsers() {
    $q = $this->getOnlineUsersQuery();
    return $q->count();
  }
  
  /**
   * returns the list of online identities
   * @return array
   */
  public function getOnlineUsers() {
    $q = $this->getOnlineUsersQuery();
    $active_conn = $q->execute();
    $online = array();
    foreach ($active_conn as $conn) {
      $online[] = array('auth_type' => $conn->getAuthType(),
            'identity' => $conn->getIdentity(),
            'auth_sub_type' => $conn->getAuthSubType());
    }
    return $online;
  }

}
