<?php

// +------------------------------------------------------------------------+
// | AuthPuppy Authentication Server                                        |
// | ===============================                                        |
// |                                                                        |
// | AuthPuppy is the new generation of authentication server for           |
// | a wifidog based captive portal suite                                   |
// +------------------------------------------------------------------------+
// | PHP version 5 required.                                                |
// +------------------------------------------------------------------------+
// | Homepage:     http://www.authpuppy.org/                                |
// | Launchpad:    http://www.launchpad.net/authpuppy                       |
// +------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify   |
// | it under the terms of the GNU General Public License as published by   |
// | the Free Software Foundation; either version 2 of the License, or      |
// | (at your option) any later version.                                    |
// |                                                                        |
// | This program is distributed in the hope that it will be useful,        |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of         |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          |
// | GNU General Public License for more details.                           |
// |                                                                        |
// | You should have received a copy of the GNU General Public License along|
// | with this program; if not, write to the Free Software Foundation, Inc.,|
// | 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.            |
// +------------------------------------------------------------------------+


/**
 * Connection
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    authpuppy
 * @author     Geneviève Bastien <gbastien@versatic.net>
 * @author     Philippe April <philippe@philippeapril.com>
 * @copyright  2010
 * @version    $Version: 0.1.0$
 */
class Connection extends BaseConnection
{

  public static $WAITING_TOKEN_VALIDATION = "WAITING_TOKEN_VALIDATION";
  public static $TOKEN_VALIDATED = "TOKEN_VALIDATED";
  public static $LOGGED_OUT = "LOGGED_OUT";
  public static $EXPIRED = "EXPIRED";
  
  public function setUp() {
    parent::setUp();
    sfProjectConfiguration::getActive()->getEventDispatcher()->filter(new sfEvent($this,'connection.set_up', array('connection' => $this)),$this);
  }

  public function assignDefaultValues($overwrite = false) {
    /* Generate a new token */
    parent::assignDefaultValues($overwrite);
    $this->setToken(apUtils::generateNonce());
    $this->setStatus(Connection::$WAITING_TOKEN_VALIDATION);
  }
  
  public function getDuration() {
    $difftime = strtotime($this->getUpdatedAt()) - strtotime($this->getCreatedAt());
    return $difftime;
  }

  public function expireIfNotRecentlyUpdated() {
    /* FIXME HARDCODED VALUE */
    if (time() - date_format(date_create($this->getUpdatedAt()), "U") > 60* (apAuthpuppyConfig::getConfigOption("connection_expiry", 30))) {
      $this->setStatus(Connection::$EXPIRED);
      $this->save();
    }
  }

}
